<?php

session_start();
require('diag.php');
//include '../mks_db_connect.php';
//require('../fpdf181/fpdf.php');
//require('fpdf.php');

// Stream handler to read from global variables
class VariableStream
{
    private $varname;
    private $position;
    
    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }
    
    function stream_stat()
    {
        return array();
    }
}

class PDF_Report extends PDF_Diag
{
    function __construct($orientation='P', $unit='mm', $format='A4')
    {
        parent::__construct($orientation, $unit, $format);
        // Register var stream protocol
        stream_wrapper_register('var', 'VariableStream');
    }

    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the GD image associated with $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }
    
    //inserted
    function Footer()
    {
        // Go to 1.5 cm from bottom
        $this->SetY(-15);
        // Select Arial italic 8
        $this->SetFont('Arial','',7.5);
        // Print centered page number
        $this->SetFont('Arial','B',7.5);$this->Cell(20,5,'Key to Codes:',0,0); $this->SetFont('Arial','',7.5);$this->Cell(40,5,'A = High Distinction (85-100%) ',0,0); $this->Cell(35,5,'C = Credit (65-74%) ',0,0);$this->Cell(44,5,'E = Pass (50-54%) ',0,0);
        $this->SetFont('Arial','B',7.5);$this->Cell(35,5,'For any queries contact:',0,0);$this->SetFont('Arial','',7.5);$this->Cell(40,5,'Academic & Student Affairs,',0,1);
        $this->SetX(30);$this->Cell(40,5,'B = Distinction (75-84%) ',0,0); $this->Cell(35,5,'D = Upper Pass (55-64%) ',0,0);$this->Cell(50,5,'F = Fail (0-49%)',0,0);
        
        //address
        $this->Cell(30,5,'University of Natural Resources, P.O BOX 12, Kokopo, ENB, PNG',0,1);
        
        //other keys
        //$this->Cell(23,5,'S = Satisfactory,',0,0);$this->Cell(28,5,'US = Unsatisfactory,',0,0);
        //$this->Cell(30,5,'CP = Conceded Pass,',0,0);
        //$this->SetX(30);
        //$this->Cell(100,5,'S = Satisfactory, US = Unsatisfactory, EX = Subject Exempted, CP = Conceded Pass, WD = Withrawn, DNS = Did Not Sit, NR = Not Registered',0,0);
        /*$this->Cell(25,5,'US = Unsatisfactory,',0,0);
        $this->Cell(35,5,'EX = Subject Exempted,',0,0);
        $this->Cell(35,5,'CP = Conceded Pass,',0,0);
        $this->Cell(30,5,'WD = Withrawn,',0,0);
        $this->Cell(30,5,'NR = Not Registered',0,0);*/
        
        //address - phone numbers
        $this->SetX(199);
        //$this->Cell(30,5,'Phone: (675) 4734287/ 4734289/ 4734281, Direct Fax: (675) 4734286',0,0);
    }
    function Header()
    {
        if ($this->PageNo()>1){
            $this->Cell(60,5,'Student Academic Transcript for '.$_SESSION['stdname'].' (continued)',0,1);
            $this->Ln();
        }
        
    }
}

?>
