<?php

session_start();
require('diag.php');
//include '../mks_db_connect.php';
//require('../fpdf181/fpdf.php');
//require('fpdf.php');

// Stream handler to read from global variables
class VariableStream
{
    private $varname;
    private $position;
    
    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }
    
    function stream_stat()
    {
        return array();
    }
}

class PDF_Report extends PDF_Diag
{
    function __construct($orientation='P', $unit='mm', $format='A4')
    {
        parent::__construct($orientation, $unit, $format);
        // Register var stream protocol
        stream_wrapper_register('var', 'VariableStream');
    }

    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the GD image associated with $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }
    
    //inserted
    function Footer()
    {
        // Go to 1.5 cm from bottom
        //$this->SetY(-15);
        // Select Arial italic 8
        //$this->SetFont('Arial','I',8);
        // Print centered page number
        //$this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
    }
    function Header()
    {
        if ($this->PageNo()>1){

            $logo = file_get_contents('unre_logo.png');
            // Output it
             $this->MemImage($logo, 5, 5,15,15);
             //echo "test";
             $this->SetFont('helvetica','B',12);
             $this->SetXY(20,5);
             $this->Cell(50,10,'PNG UNIVERSITY OF NATURAL RESOURCES & ENVIRONMENT');
             $this->Ln();
             $this->SetXY(20,12);
             $this->SetFont('helvetica','B',14);
             $this->Cell(50,10,'REGISTRATION OF ENROLMENT');
             //rule lines
             $this->Line(5, 5, 5, 205);
             $this->Line(5, 205, 292, 205);
             $this->Line(292, 5, 292, 205);
             $this->Line(5, 5, 292, 5);

             //$this->Line(151, 5, 151, 205);
             $this->Line(5, 20, 292, 20);

             $this->SetFont('helvetica','',10);
             $this->SetY(5);
             //$this->Write(6, 'Some writing...');
             //$this->Ln(); 
             $this->SetFont('helvetica','B',14);
             //$this->SetX(276);
             //$this->Cell(40,10,'REGISTRATION FORM '.$currentyear);
             $this->Ln(15); 
             $this->SetXY(155,7.5);
            $this->SetFont('helvetica','B',12);
            $this->Cell(50,10,'PROCEED LIST 2023',0,1);
             //$this->SetFont('helvetica','B',12);
             //$this->Cell(40,10,'PRELISTING REGISTRATION REPORT');

             $this->SetFont('helvetica','B',11);
             $this->SetX(0);
             $this->Ln(); 
             
             $this->Cell(20,7,"STUD #");
            $this->Cell(35,7,"Surname");
            $this->Cell(35,7,"Name");
            $this->Cell(20,7,"Gender");
            $this->Cell(18,7,"Program");
            $this->Cell(10,7,"YOS");
            $this->Cell(20,7,"Status");
            $this->Cell(20,7,"B&L Fees");
            $this->Cell(25,7,"Sponsor");
            $this->Cell(30,7,"RM/DM/ML #",0,0);
            $this->Cell(30,7,"Payment Policy",0,0);


        }
        
    }
}

?>
