<?php

session_start();
//require('diag.php');
require('dash.php');
include '../mks_db_connect.php';

// Stream handler to read from global variables
class VariableStream
{
    private $varname;
    private $position;
    
    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }
    
    function stream_stat()
    {
        return array();
    }
}

class PDF_Report extends PDF_Dash
{
    function __construct($orientation='P', $unit='mm', $format='A4')
    {
        parent::__construct($orientation, $unit, $format);
        // Register var stream protocol
        stream_wrapper_register('var', 'VariableStream');
    }

    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the GD image associated with $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }
    
    //inserted
    function Footer()
    {
        // Go to 1.5 cm from bottom
        $this->SetY(-15);
        // Select Arial italic 8
        $this->SetFont('Arial','',7.5);
        // Print centered page number
        $this->SetFont('Arial','B',7.5);$this->Cell(20,5,'Grade Symbol:',0,0); $this->SetFont('Arial','',7.5);$this->Cell(40,5,'HD = High Distinction (85-100%) ',0,0); $this->Cell(35,5,'CR = Credit (65-74%) ',0,0); $this->Cell(85,5,'PA = Pass (50-54%) ',0,1); //$this->Cell(25,5,'P = Pass',0,0);$this->Cell(35,5,'SP = Sup Exam Pass',0,0);$this->Cell(35,5,'CP = Considered Pass',0,1);
        $this->SetFont('Arial','B',7.5);$this->SetFont('Arial','',7.5);//$this->Cell(40,5,'Department of Open & Distance Learning,',0,1);
        $this->SetX(30);$this->Cell(40,5,'DI = Distinction (75-84%) ',0,0); $this->Cell(35,5,'UP = Upper Pass (55-64%) ',0,0);$this->Cell(85,5,'FA = Fail (0-49%)',0,0); $this->Cell(25,5,'EX = Exempted',0,0);$this->Cell(35,5,'WD = Withdrawn',0,0);
        
        //address
        //$this->Cell(30,5,'University of Technology, PMB Service, Lae, Papua New Guinea',0,1);
        
        
        //address - phone numbers
        $this->SetX(195);
        //$this->Cell(30,5,'Phone: (675) 4734287/ 4734289/ 4734281, Direct Fax: (675) 4734286',0,0);

    }
    function Header()
    {
        if ($this->PageNo()==1){
            $logo = file_get_contents('unreologo.png');
            // Output it
            $this->MemImage($logo, 45, 0,200,35);
            //$this->MemImage($logo, 208, 10,20,25);
//echo "test";
            //$this->Cell(0,5,'test',1,0);
            $this->Ln();
            //$this->Ln();
            //echo "test";
            
            //$this->SetXY(0,35);
            
            
            //$this->SetXY(100,18);
            //$this->Cell(90,5,'',0,1,'C');
            //$this->Ln(30);
            //$this->Cell(10,5,'ACADEMIC TRANSCRIPT',0,0);
            
            //$this->SetLineWidth(1);
            $this->Line(10, 45, 285, 45);
            
            //$this->Cell(10,5,'ACADEMIC TRANSCRIPT',0,0);
            //$this->Ln();
            $this->SetFont('Arial', '', 11);$this->SetXY(130,38);$this->Cell(40,5,'ACADEMIC TRANSCRIPT',0,1);$this->SetY(10);$this->Ln(38);
            $this->Cell(30,5,'Student Name:',0,0);$this->SetFont('Arial', 'B', 11);$this->Cell(60,5,$_SESSION['stdname'],0,0); $this->SetFont('Arial', '', 11); $this->Cell(24,5,'StudentID:',0,0); $this->SetFont('Arial', 'B', 11); $this->Cell(38,5,$_SESSION['stdid'],0,0); $this->SetFont('Arial', '', 11);  $this->Cell(12,5,'Sex: ',0,0); $this->SetFont('Arial', 'B', 11); $this->Cell(67,5,$_SESSION['sex'],0,0); $this->SetFont('Arial', '', 11); $this->Cell(100,5,'Page '.$this->PageNo().' of '.'{nb} page(s)',0,1);
            $this->SetDash(1,1);
            $this->Line(10, 55, 285, 55);
            //$this->Ln();
           //echo "test2";
        }
        if ($this->PageNo()>1){
            //$this->Cell(60,5,'Student Academic Transcript for '.$_SESSION['stdname'].' (continued)',0,1);
            $this->Cell(60,5,'Student Academic Transcript (continued)',0,1);
            //$this->Ln();
            
            $logo = file_get_contents('unre_logo_2.png');
            // Output it
            $this->MemImage($logo, 145, 5,14,14);
            
            $this->Line(10, 20, 285, 20);
            $this->Ln(8);
            $this->SetFont('Arial', '', 11);
            $this->Cell(30,5,'Student Name:',0,0);$this->SetFont('Arial', 'B', 11);$this->Cell(60,5,$_SESSION['stdname'],0,0); $this->SetFont('Arial', '', 11); $this->Cell(24,5,'StudentID:',0,0); $this->SetFont('Arial', 'B', 11); $this->Cell(38,5,$_SESSION['stdid'],0,0); $this->SetFont('Arial', '', 11);  $this->Cell(12,5,'Sex: ',0,0); $this->SetFont('Arial', 'B', 11); $this->Cell(67,5,$_SESSION['sex'],0,0); $this->SetFont('Arial', '', 11); $this->Cell(100,5,'Page '.$this->PageNo().' of '.'{nb} page(s)',0,1);
            $this->SetDash(1,1);
            $this->Line(10, 30, 285, 30);
            $this->Ln();
        }
        /*if ($this->PageNo()>1){
            $this->SetFillColor(128,0,21);
            //$this->SetF
            $this->SetFont('Arial', 'B', 12);
            $this->SetTextColor(255,215,0);
            $this->Ln();
            $this->Cell(275,5,$_SESSION['crrntcs'],0,1,'L',1);
            $this->SetTextColor(0,0,0);
            $this->SetFont('Arial', 'B', 10);
            $this->Cell(30,5,'Year',0,0);
            $this->Cell(50,5,'Session',0,0);
            $this->Cell(40,5,'Code',0,0);
            $this->Cell(120,5,'Subject Title',0,0);
            $this->Cell(40,5,'Grade',0,0);
            //$this->Ln();
            $this->SetLineWidth(0);
            $this->SetDash(1,1);
            $this->Line(10, 67, 285, 67);
            $this->Ln();
        }*/
        
    }
}

?>
