<?php
session_start();
require('diag.php');
//require('../fpdf181/fpdf.php');
//require('fpdf.php');

// Stream handler to read from global variables
class VariableStream
{
    private $varname;
    private $position;

    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }
    
    function stream_stat()
    {
        return array();
    }
}

class PDF_Report extends PDF_Diag
{
    function __construct($orientation='P', $unit='mm', $format='A4')
    {
        parent::__construct($orientation, $unit, $format);
        // Register var stream protocol
        stream_wrapper_register('var', 'VariableStream');
    }

    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the GD image associated with $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }
    
    //inserted
    function Footer()
    {
        // Go to 1.5 cm from bottom
        $this->SetY(-15);
        // Select Arial italic 8
        $this->SetFont('Arial','I',8);
        // Print centered page number
        //$this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
        $this->Cell(0, 5, '"Note that these are provisional marks only until the Academic Board next meeting for endorsement in 2020"', 0, 1,'C');
    }
    /*function Header()
    {
        //$pdf->Ln(10);
        $this->SetTextColor(0,0,0);
        $this->SetFont('Arial', 'B', 14);
        //$pdf->SetTextColor(65,65,125);
        $this->Cell(40, 5, 'PNG University of Technology', 0, 1);
        //$pdf->Ln();
        $this->Cell(40, 5, 'Students with outstanding fees 2018', 0, 1);
        $this->Ln();

        //sort the list 
        $this->SetFont('Arial', 'B', 9);
        $this->Cell(20,5,'StudentID',1);
        $this->Cell(40,5,'StudentName',1);
        $this->Cell(20,5,'Amount (K)',1);
        $this->Cell(70,5,'Sponsor',1);
        $this->Cell(20,5,'Course',1);
        $this->Cell(20,5,'Level',1);
        $this->Ln();
    }*/
}
?>
