<?php
session_start();
require('diag.php');
//require('../fpdf181/fpdf.php');
//require('fpdf.php');
include '../mks_db_connect.php';

// Stream handler to read from global variables
class VariableStream
{
    private $varname;
    private $position;

    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }
    
    function stream_stat()
    {
        return array();
    }
}

class PDF_Report extends PDF_Diag
{
    function __construct($orientation='P', $unit='mm', $format='A4')
    {
        parent::__construct($orientation, $unit, $format);
        // Register var stream protocol
        stream_wrapper_register('var', 'VariableStream');
    }

    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the GD image associated with $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }
    
    //inserted
    function Footer()
    {
        $this->SetFont('Arial','',9);
        // Go to 4 cm from bottom
        $this->SetY(-20);
            $cn=new ConnectMySQL();
            $cn->connectdb();
            $myconstd=$cn->constd;
            //$myconstd = new mysqli("localhost", "root", "Wat0m1au", "studentdb");
            //$_SESSION['course']='BSCS';$_SESSION['level']='4';
            $rescosname=$myconstd->query("Select Description, CourseID from course where CourseID ='".$_SESSION['course']."'");
                $rowcosname= $rescosname->fetch_assoc();
        $course=$rowcosname['CourseID'];
        $level=$_SESSION['level']; 
        $yr=substr($_SESSION['crrntyrsem'],0,4);
        //$this->Cell(200,10,'GPAs for students taking year 1 of BSAG in 2019. Credit hours for all subjects are taken from 2019. (0813 74.2) indicates a year (08), semester (1), level (3) and metric (74.2). The first number in each line is the cumulative metric across all listed semesters.',0,1,'L',false);
        $txt="NOTE: GPAs for students taking year $level of $course in $yr. Credit hours for all subjects are taken from $yr. (2123 3.12) indicates a year (21), semester (2), level (3) and metric (3.12). The first number in each line is the cumulative metric across all listed semesters.";
        $this->MultiCell(0, 5, $txt);
        // Go to 1.5 cm from bottom
        $this->SetY(-15);
        // Select Arial italic 8
        $this->SetFont('Arial','I',8);
        // Print centered page number
        $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
    }
    function Header()
    {
        $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(46,0,255);
        //$pdf->SetTextColor(65,65,125);
           
        $this->Cell(200, 5, 'Papua New Guinea University of Natural Resources and Environment', 0);
        //$pdf->Ln();
        $this->SetTextColor(0,0,0);
         $this->SetFont('Arial', 'I', 10);
            $this->Cell(50, 5, 'Printed Date: '.date('Y-m-d H:i:s')); 
            $this->Ln();
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(200,45,30);
            $this->SetTextColor(0,0,0);
        
        $this->Cell(200, 5, 'Student GPAs for '.substr($_SESSION['crrntyrsem'], 0, 4), 0);
        
        $this->SetTextColor(0,0,0);
         $this->SetFont('Arial', 'BI', 10);
            $this->Cell(50, 5, 'Surname in uppercase'); 
            //$this->Ln();
            
        $this->SetFont('Arial', 'B', 14);
        $this->SetTextColor(18,65,125);
        //$this->Cell(40, 5, 'Bachelor of Science in Agrculture ( B.Sc. (Ag.) ) Year 1', 0, 1);
            $cn=new ConnectMySQL();
            $cn->connectdb();
            $myconstd=$cn->constd;
            $rescosname=$myconstd->query("Select Description, CourseID from course where CourseID ='".$_SESSION['course']."'");
                $rowcosname= $rescosname->fetch_assoc();
            $this->SetTextColor(80,50,250);
            if ($rowcosname['CourseID']!='-'){
                $this->SetXY(10, 20);$this->SetFont('Arial', 'B', 12);$this->Cell(40, 5, $rowcosname['Description']."  ( ".$rowcosname['CourseID']." )    Year ".$_SESSION['level']);

            }else{
                $this->SetXY(10, 20);$this->SetFont('Arial', 'B', 12);$this->Cell(40, 5, $rowcosname['Description']."  ( ".$_SESSION['course']." )   Year ".$_SESSION['level']);
            }
            $this->Ln(10);
         
        //sort the list 
        $this->SetTextColor(65,12,200);
        $this->SetFont('Arial', 'B', 11);
          $this->Cell(10,5,'No.',1,0,'C');
            $this->Cell(20,5,'StudentID',1);
            $this->Cell(50,5,'Student Name',1);
          
            $this->Cell(150,5,'Cummulative GPA',1,0);
            $this->Cell(35,5,'Decision',1,0);
             $this->Ln();
    }
}
?>
