<?php

session_start();
require('diag.php');
include '../mks_db_connect.php';
//require('../fthis181/fthis.php');
//require('fthis.php');

// Stream handler to read from global variables
class VariableStream
{
    private $varname;
    private $position;
    
    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }
    
    function stream_stat()
    {
        return array();
    }
}

class PDF_Report extends PDF_Diag
{
    function __construct($orientation='P', $unit='mm', $format='A4')
    {
        parent::__construct($orientation, $unit, $format);
        // Register var stream protocol
        stream_wrapper_register('var', 'VariableStream');
    }

    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the GD image associated with $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }
    
    //inserted
    function Footer()
    {
        // Go to 1.5 cm from bottom
        $this->SetY(-15);
        // Select Arial italic 8
        $this->SetFont('Arial','I',8);
        // Print centered page number
        $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'R');
        
        if ($this->GetY() >= 275) {
            $this->Line(10, 275, $_SESSION['endofpglength']+10, 275);
        }
    }
    function Header()
    {
        //$logo = file_get_contents('../transcripts/unre_logo.png');
            // Output it
            //$this->MemImage($logo, 10, 10,24,24);
        $this->SetFont('Arial', 'B', 8);
        if ($this->PageNo()>1){
            $this->SetFillColor(143,188,143);
            //$this->SetTextColor(255);
            $this->SetDrawColor(0,100,0);
            $this->SetLineWidth(.3);
            //set row 1
            $cn=new ConnectMySQL();
            $cn->connectdb();
            $myconstd=$cn->constd;
            $resassitm=$myconstd->query("select * from assessmentitem where CourseCode ='".$_SESSION['crrntsubjectid']."' and YearSemester =20242 order by AddDate");
            $cosassitm = array();
            $cosassitm = $resassitm->fetch_all(MYSQLI_ASSOC);
            $this->Cell(20,5,'STDNUM','LTR',0,'C');$this->Cell(40,5,'Surname','TR');$this->Cell(40,5,'Names','TR');$this->Cell(15,5,'Program','TR',0,'C');$this->Cell(15,5,'Level','TR',0,'C');
            for ($i=1;$i<=count($cosassitm);$i++){
                $this->Cell(40,5,$cosassitm[$i-1]['ItemName'],'TR',0,'C');

            }

            $this->Cell(20,5,'Coursework','TR',0,'C');$this->Cell(20,5,'Cum (%)','TR',0,'C');$this->Cell(15,5,'Grade','TR',0,'C');$this->Cell(15,5,'GPA','TR',1,'C');
            //sort the list 

            //set row 2
            $this->Cell(20,5,'','LRB',0,'C');$this->Cell(40,5,'','BR');$this->Cell(40,5,'','BR');$this->Cell(15,5,'','BR',0,'C');$this->Cell(15,5,'','BR',0,'C');
            //get MAF
            
            for ($i=1;$i<=count($cosassitm);$i++){
                $this->Cell(20,5,$cosassitm[$i-1]['Max'],'TRB',0,'C');
                $this->Cell(20,5,$cosassitm[$i-1]['Weight'],'TRB',0,'C');

            }
            $this->Cell(20,5,'','LRB',0,'C');$this->Cell(20,5,'','LRB',0,'C');$this->Cell(15,5,'','LRB',0,'C');$this->Cell(15,5,'','LRB',1,'C');
        }
        
    }
}

?>
