<?php

session_start();
require('diag.php');
include '../mks_db_connect.php';
//require('../fpdf181/fpdf.php');
//require('fpdf.php');

// Stream handler to read from global variables
class VariableStream
{
    private $varname;
    private $position;
    
    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }
    
    function stream_stat()
    {
        return array();
    }
}

class PDF_Report extends PDF_Diag
{
    function __construct($orientation='P', $unit='mm', $format='A4')
    {
        parent::__construct($orientation, $unit, $format);
        // Register var stream protocol
        stream_wrapper_register('var', 'VariableStream');
    }

    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        // Display the GD image associated with $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }
    
    //inserted
    function Footer()
    {
        // Go to 1.5 cm from bottom
        $this->SetY(-15);
        // Select Arial italic 8
        $this->SetFont('Arial','I',8);
        // Print centered page number
        $this->Cell(0,10,'Page '.$this->PageNo().' of '.'{nb} page(s)',0,0,'R');
    }
    function Header()
    {
        $logo = file_get_contents('../transcripts/unre_logo_2.png');
            // Output it
            $this->MemImage($logo, 10, 10,24,24);
        
        if ($_SESSION['crrntreport']=='stats' && $_SESSION['dept']!='sa'){
            $this->SetFont('Arial', 'B', 14);
            //$this->SetMargins(15, 10, 5.0);

            //$pdf->SetAutoPageBreak(1, 0.5);
            //$logo = file_get_contents('../myuni.jpg');
            // Output it
            //$this->MemImage($logo, 50, 5);
               
            //$_SESSION['deptname']='Computer Science';
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(65,65,125);

            $this->SetXY(10, 10);
            $this->Cell(100, 5, 'Summary Statistics');
            $this->Cell(70, 5, substr($_SESSION['crrntyrsem'], 0, 4).' Semester '.substr($_SESSION['crrntyrsem'], 4, 1)); 
            $this->SetFont('Arial', 'I', 10);
            $this->SetTextColor(0,0,0);
            $this->Cell(50, 5, 'Printed Date: '.date('Y-m-d H:i:s')); 
            $this->Ln();
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(0,0,0);
            $this->SetXY(10, 15);
            $this->Cell(50, 5, 'Papua New Guinea University of Natural Resources and Environment');
            //$this->Ln();
            $this->SetXY(10, 20);$this->SetFont('Arial', '', 12);
            $this->Cell(50, 5, 'Department of '.$_SESSION['deptname']);
            
            $this->SetFont('Arial', 'B', 12);
            

            $this->Ln(10);
            return;
        }
        if ($_SESSION['crrntreport']=='mer' && $_SESSION['dept']!='sa'){
            $this->SetFont('Arial', 'B', 14);
            //$this->SetMargins(15, 10, 5.0);

            //$pdf->SetAutoPageBreak(1, 0.5);
            //$logo = file_get_contents('../myuni.jpg');
            // Output it
            //$this->MemImage($logo, 50, 5);

            //$_SESSION['deptname']='Computer Science';
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(65,65,125);

            $this->SetXY(10, 10);
            $this->Cell(100, 5, 'Master Examination Result Sheet');
            $this->Cell(70, 5, substr($_SESSION['crrntyrsem'], 0, 4).' Semester '.substr($_SESSION['crrntyrsem'], 4, 1)); 
            $this->SetFont('Arial', 'I', 10);
            $this->SetTextColor(0,0,0);
            $this->Cell(50, 5, 'Printed Date: '.date('Y-m-d H:i:s')); 
            $this->Ln();
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(0,0,0);
            $this->SetXY(10, 15);
            $this->Cell(50, 5, 'Papua New Guinea University of Natural Resources And Environment');
            //$this->Ln();
            $this->SetXY(10, 20);$this->SetFont('Arial', '', 12);
            $this->Cell(50, 5, 'Department of '.$_SESSION['deptname']);

            //$myconmks = new mysqli("localhost", "root", "Wat0m1au", "marksdb");
            //$myconstd = new mysqli("202.1.32.11", "fkikile", "Gal1l30", "studentdb");
            //$myconstd=$con_std;
            $cn=new ConnectMySQL();
            $cn->connectdb();
            $myconstd=$cn->constd;
            //$myconstd = new mysqli("localhost", "root", "Wat0m1au", "studentdb");
            //$_SESSION['course']='BSCS';$_SESSION['level']='4';
            $rescosname=$myconstd->query("Select Description, CourseID from course where CourseID ='".$_SESSION['course']."'");
                $rowcosname= $rescosname->fetch_assoc();
            $this->SetTextColor(80,50,250);
            if ($rowcosname['CourseID']!='-'){
                $this->SetXY(10, 25);$this->SetFont('Arial', 'B', 12);$this->Cell(50, 5, $rowcosname['Description']."  ( ".$rowcosname['CourseID']." )    Year ".$_SESSION['level']);

            }else{
                $this->SetXY(10, 25);$this->SetFont('Arial', 'B', 12);$this->Cell(50, 5, $rowcosname['Description']."  ( ".$_SESSION['course']." )   Year ".$_SESSION['level']);
            }
            $this->Ln(10);
            return;
        }
        
        if ($_SESSION['crrntreport']=='mer' && $_SESSION['dept']=='sa'){
            $this->SetFont('Arial', 'B', 14);
            //$this->SetMargins(15, 10, 5.0);

            //$pdf->SetAutoPageBreak(1, 0.5);
            //$logo = file_get_contents('../myuni.jpg');
            // Output it
            //$this->MemImage($logo, 50, 5);

            //$_SESSION['deptname']='Computer Science';
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(65,125,65);

            $this->SetXY(10, 10);
            $this->Cell(275, 5, $_SESSION['sa_school'],0,0,'C');
            //$this->Cell(90, 5, substr($_SESSION['crrntyrsem'], 0, 4).' Semester '.substr($_SESSION['crrntyrsem'], 4, 1)); 
            $this->SetFont('Arial', 'I', 10);
            $this->SetTextColor(0,0,0);
            //$this->Cell(50, 5, 'Printed Date: '.date('Y-m-d H:i:s')); 
            $this->Ln();
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(0,0,0);
            $this->SetXY(10, 15);
            $this->Cell(275, 5, 'Department of '.$_SESSION['sa_deptname'],0,0,'C');
            //$this->Ln
            //
            $this->SetXY(10, 20);$this->SetFont('Arial', '', 14);
            $this->Cell(275, 5, substr($_SESSION['crrntyrsem'], 0, 4).' Semester '.substr($_SESSION['crrntyrsem'], 4, 1).' Examination Results ',0,0,'C');
            
            $this->SetXY(35, 29);
            $this->SetFillColor(34,139,34);
            $this->SetTextColor(255,215,0);
            $this->SetFont('Arial', 'B', 12);
            $this->Cell(250, 5, 'Program Name: '.$_SESSION['programdesc'],0,0,'L',true);
            $this->Cell(50, 5, "Code: ".$_SESSION['course'],0,0,'L',true);
            $this->Cell(20, 5, "Year: ".$_SESSION['level'],0,0,'L',true);
            $this->SetFillColor(0,0,0);
            $this->SetTextColor(0,0,0);
                    
            $this->SetDrawColor(0,100,0);
            $this->SetLineWidth(.3);
            $this->Line(10, 34.5, 410.5,34.5);
            $this->Line(10, 275, 410.5,275);
            $this->SetY(25);
            $this->Ln(10);
            return;
        }
        
        if ($_SESSION['crrntreport']=='stats' && $_SESSION['dept']=='sa'){
            $this->SetFont('Arial', 'B', 14);
            //$this->SetMargins(15, 10, 5.0);

            //$pdf->SetAutoPageBreak(1, 0.5);
            //$logo = file_get_contents('../myuni.jpg');
            // Output it
            //$this->MemImage($logo, 50, 5);

            //$_SESSION['deptname']='Computer Science';
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(65,65,125);

            $this->SetXY(10, 10);
            $this->Cell(100, 5, 'Summary Statistics');
            $this->Cell(70, 5, substr($_SESSION['crrntyrsem'], 0, 4).' Semester '.substr($_SESSION['crrntyrsem'], 4, 1)); 
            $this->SetFont('Arial', 'I', 10);
            $this->SetTextColor(0,0,0);
            $this->Cell(50, 5, 'Printed Date: '.date('Y-m-d H:i:s')); 
            $this->Ln();
            $this->SetFont('Arial', 'B', 14);
            $this->SetTextColor(0,0,0);
            $this->SetXY(10, 15);
            $this->Cell(50, 5, 'Papua New Guinea University of Natural Resources And Environment');
            //$this->Ln();
            $this->SetXY(10, 20);$this->SetFont('Arial', '', 12);
            $this->Cell(50, 5, 'Department of '.$_SESSION['sa_deptname']);
            
            $this->SetFont('Arial', 'B', 12);
            

            $this->Ln(10);
            return;
        }
        
    }
}

?>
